﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.Business.Utilities;

using VeteransAffairs.Registries.BusinessManager;

public partial class RegistryMaster : System.Web.UI.MasterPage
{
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    /// <summary>
    /// This script sets a focus to the control with a name to which
    /// REQUEST_LASTFOCUS was replaced. Setting focus heppens after the page
    /// (or update panel) was rendered. To delay setting focus the function
    /// window.setTimeout() will be used.
    /// </summary>
    private const string SCRIPT_DOFOCUS =
        @"window.setTimeout('DoFocus()', 1);
        function DoFocus()
        {
            try {
                document.getElementById('REQUEST_LASTFOCUS').focus();
            } catch (ex) {}
        }";
    public delegate void MasterPageMenuClickHandler(object sender, MenuEventArgs e);

    public event MasterPageMenuClickHandler MenuClick;

    private string GetContextSensitiveHelpURL()
    {
        return "~/help/" + Page.Page.ToString().Substring(4).Replace("_aspx", ".html");
    }
    
    protected void Page_Load(object sender, EventArgs e)
    {

        UserAccountManager user = (UserAccountManager)HttpContext.Current.User;

        //var config = RegistriesConfigurations.GetConfig();
        //var display = config == null ? true : config.DisplayUser; 

        if (Convert.ToBoolean(Helpers.GetConfigEntry("DisplayUser")) == true)
        //if (display)
        {
            lblCurrentDateTime.Text = DateTime.Now.ToString();
            lblCurrentUser.Text = user.FullName;
            lblRole.Text = user.RoleName;
            Label1.Visible = true;
            Label2.Visible = true;
            lblCurrentDateTime.Visible = true;
            lblCurrentUser.Visible = true;
            lblRole.Visible = true;
        }

        //Set onfocus event to all apropriate controls on the page.
        if (!IsPostBack)
        {
            HookOnFocus(this.Page as Control);

            string sReportingLink = Helpers.GetDBConfigEntry("TBIReportingLink");

            MenuHorizontalMenu.Items.Add(new MenuItem("My Tasks", "My Tasks", "", "~/Referrals.aspx"));
            MenuHorizontalMenu.Items.Add(new MenuItem("Patients", "Patients", "", "~/PolyTraumaPatients.aspx"));
            MenuHorizontalMenu.Items.Add(new MenuItem("Reporting", "Reporting", "", sReportingLink, "_blank"));
            MenuHorizontalMenu.Items.Add(new MenuItem("Administration", "Administration", "", "~/AdminListUsers.aspx"));
            MenuHorizontalMenu.Items.Add(new MenuItem("Help", "Help", "images/help.gif", "", "_blank"));

            // Sets the correct URL for context sensitive help, based on content page
            MenuHorizontalMenu.Items[4].NavigateUrl = GetContextSensitiveHelpURL();
        }

        MenuBuilder.SetMyTasksLink(MenuHorizontalMenu);
        MenuBuilder.SetPatientLink(MenuHorizontalMenu);
        
        ////Get menu list based on user access
        //string[] pages = user.GetPagesByCode();
        ////Populate menu list
        //MenuBuilder.GetLeftMenuList(MenuLeftNavigation, pages);
        //Make user information visible

        //if (!IsPostBack)
        //    MenuLeftNavigation.Attributes.Add("onclick", "menuClickHandler(this);"); 
    }


    /// <summary>
    /// This function goes recursively all child controls and sets 
    /// onfocus attribute if the control has one of defined types.
    /// </summary>
    /// <param name="CurrentControl">the control to hook.</param>
    private void HookOnFocus(Control CurrentControl)
    {
        //checks if control is one of TextBox, DropDownList, ListBox or Button

        if ((CurrentControl is TextBox) ||
            (CurrentControl is DropDownList) ||
            (CurrentControl is ListBox) ||
            (CurrentControl is CheckBoxList) ||
            (CurrentControl is RadioButton) ||
            (CurrentControl is Button))

            //Fortify errors on this line (CurrentControl as WebControl).Attributes.Add(
            ((WebControl)CurrentControl).Attributes.Add(
               "onfocus",
               "try{document.getElementById('__LASTFOCUS').value=this.id} catch(e) {}"
            );

        //checks if the control has children
        if (CurrentControl.HasControls())
            //if yes do them all recursively

            foreach (Control CurrentChildControl in CurrentControl.Controls)
                HookOnFocus(CurrentChildControl);
    }

    protected void MenuItemClick(object sender, MenuEventArgs e)
    {

        if (MenuClick != null)
        {
            MenuClick(sender, e);
        }

        //    MenuBuilder.SetMenuItemHighlight(MenuLeftNavigation.Items, e.Item.Value);

    }

    //public VeteransAffairs.Registries.DirtyPanelExtender.DirtyPanelExtender DirtyPanelExtender
    //{
    //    get
    //    {
    //        return MasterPanelExtender;
    //    }
    //}

    public void SetDirtyFlag(bool flag)
    {

        dirtyFlag.Value = flag == true ? "1" : "0";


    }



}
